/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.tzupdater.utils;

import com.sun.tools.tzupdater.TzRuntimeException;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.StreamCorruptedException;
import sun.util.calendar.ZoneInfoFile;

public class UtilsHelper {
    public static String getTzID(String string) {
        String string2;
        block7: {
            string2 = null;
            try {
                byte[] byArray = UtilsHelper.readZoneInfoMappings(string);
                int n = ZoneInfoFile.JAVAZM_LABEL.length + 1;
                int n2 = byArray.length;
                while (n < n2) {
                    byte by = byArray[n++];
                    int n3 = ((byArray[n++] & 0xFF) << 8) + (byArray[n++] & 0xFF);
                    switch (by) {
                        case 68: {
                            string2 = new String(byArray, n, n3 - 1, "utf-8");
                            break block7;
                        }
                        default: {
                            n += n3;
                            break;
                        }
                    }
                }
            }
            catch (IOException iOException) {
                throw new TzRuntimeException("can't read ZoneInfoMappings at " + string, iOException);
            }
            catch (Exception exception) {
                throw new TzRuntimeException("ZoneInfoMappings file is corrupted.", exception);
            }
        }
        return string2;
    }

    public static String getTzIDFromTZDB(String string) throws IOException {
        FilterInputStream filterInputStream = null;
        try {
            filterInputStream = new DataInputStream(new BufferedInputStream(new FileInputStream(new File(string))));
            String string2 = UtilsHelper.getTzID((DataInputStream)filterInputStream);
            return string2;
        }
        catch (Exception exception) {
            throw new TzRuntimeException("Error reading tzdata version from " + string, exception);
        }
        finally {
            if (filterInputStream != null) {
                filterInputStream.close();
            }
        }
    }

    public static String getTzID(DataInputStream dataInputStream) throws Exception {
        String string = "";
        if (dataInputStream.readByte() != 1) {
            throw new StreamCorruptedException("File format not recognised");
        }
        String string2 = dataInputStream.readUTF();
        if (!"TZDB".equals(string2)) {
            throw new StreamCorruptedException("File format not recognised");
        }
        int n = dataInputStream.readShort();
        for (int i = 0; i < n; ++i) {
            string = dataInputStream.readUTF();
        }
        return "tzdata" + string;
    }

    public static byte[] readZoneInfoMappings(String string) throws IOException {
        int n;
        byte[] byArray;
        String string2 = UtilsHelper.toZiFileName(string, "ZoneInfoMappings");
        File file = new File(string2);
        FileInputStream fileInputStream = new FileInputStream(file);
        if (fileInputStream.read(byArray = new byte[n = (int)file.length()]) != n) {
            fileInputStream.close();
            throw new IOException("read error on " + string2);
        }
        fileInputStream.close();
        return byArray;
    }

    public static String toZiDirName(String string) {
        String string2 = string + File.separator + "jre" + File.separator + "lib" + File.separator + "zi";
        File file = new File(string2);
        if (file.isDirectory()) {
            return string2;
        }
        string2 = string + File.separator + "lib" + File.separator + "zi";
        file = new File(string2);
        return file.isDirectory() ? string2 : null;
    }

    public static String toTzdbFileName(String string) {
        String string2 = string + File.separator + "jre" + File.separator + "lib" + File.separator + "tzdb.dat";
        File file = new File(string2);
        if (file.exists()) {
            return string2;
        }
        string2 = string + File.separator + "lib" + File.separator + "tzdb.dat";
        file = new File(string2);
        return file.isFile() ? string2 : null;
    }

    private static String toZiFileName(String string, String string2) {
        return string + File.separator + string2;
    }
}

